import React from 'react';
import { GlassCard } from '../ui/GlassCard';
import { Button } from '../ui/Button';
import { ViewState } from '../../App';
import { Activity, Database, Play, Plus, Clock } from 'lucide-react';

interface DashboardProps {
  onNavigate: (view: ViewState) => void;
}

export const Dashboard: React.FC<DashboardProps> = ({ onNavigate }) => {
  return (
    <div className="container mx-auto px-4 pt-24 pb-12">
      <div className="flex justify-between items-end mb-8">
        <div>
          <h1 className="text-3xl font-bold text-slate-900 mb-2">داشبورد</h1>
          <p className="text-slate-500">خوش آمدید، وضعیت سیستم پایدار است.</p>
        </div>
        <Button onClick={() => onNavigate('library')}>
          <Plus className="w-4 h-4 ml-2" />
          اسکریپت جدید
        </Button>
      </div>

      {/* Stats Grid */}
      <div className="grid grid-cols-1 md:grid-cols-3 gap-6 mb-8">
        <GlassCard className="p-6">
          <div className="flex items-center justify-between mb-4">
            <div className="p-3 rounded-lg bg-blue-50 text-blue-600 border border-blue-100">
              <Database className="w-6 h-6" />
            </div>
            <span className="text-xs font-medium text-green-600 bg-green-100 px-2 py-1 rounded">+۱۲٪</span>
          </div>
          <div className="text-3xl font-bold text-slate-900 mb-1">۸</div>
          <div className="text-sm text-slate-500">اسکریپت‌های فعال</div>
        </GlassCard>

        <GlassCard className="p-6">
          <div className="flex items-center justify-between mb-4">
            <div className="p-3 rounded-lg bg-purple-50 text-purple-600 border border-purple-100">
              <Activity className="w-6 h-6" />
            </div>
            <span className="text-xs font-medium text-green-600 bg-green-100 px-2 py-1 rounded">+۵٪</span>
          </div>
          <div className="text-3xl font-bold text-slate-900 mb-1">۱۴۲</div>
          <div className="text-sm text-slate-500">کل اجراها</div>
        </GlassCard>

        <GlassCard className="p-6">
          <div className="flex items-center justify-between mb-4">
            <div className="p-3 rounded-lg bg-orange-50 text-orange-600 border border-orange-100">
              <Clock className="w-6 h-6" />
            </div>
            <span className="text-xs font-medium text-slate-500 bg-slate-100 px-2 py-1 rounded">ثابت</span>
          </div>
          <div className="text-3xl font-bold text-slate-900 mb-1">۲.۴s</div>
          <div className="text-sm text-slate-500">میانگین زمان اجرا</div>
        </GlassCard>
      </div>

      {/* Recent Activity */}
      <div className="grid grid-cols-1 lg:grid-cols-3 gap-8">
        <div className="lg:col-span-2">
          <h2 className="text-xl font-bold text-slate-900 mb-4">اجراهای اخیر</h2>
          <div className="bg-white border border-slate-200 rounded-2xl overflow-hidden shadow-sm">
            {[1, 2, 3, 4].map((i) => (
              <div key={i} className="p-4 flex items-center justify-between border-b border-slate-100 last:border-0 hover:bg-slate-50 transition-colors">
                <div className="flex items-center gap-4">
                  <div className={`w-2 h-2 rounded-full ${i === 1 ? 'bg-green-500' : 'bg-slate-400'}`}></div>
                  <div>
                    <div className="text-slate-900 font-medium">تولید محتوا با AI</div>
                    <div className="text-xs text-slate-500">۲ دقیقه پیش • موفق</div>
                  </div>
                </div>
                <div className="text-slate-400 text-sm font-mono">ID: #8X29{i}</div>
              </div>
            ))}
          </div>
        </div>

        <div>
          <h2 className="text-xl font-bold text-slate-900 mb-4">دسترسی سریع</h2>
          <div className="space-y-4">
             <GlassCard className="p-4 cursor-pointer hover:bg-slate-50 transition-colors flex items-center gap-4 group">
                <div className="w-10 h-10 rounded-lg bg-purple-50 border border-purple-100 flex items-center justify-center text-purple-600 group-hover:text-white group-hover:bg-purple-600 transition-all">
                  <Play className="w-5 h-5" />
                </div>
                <div>
                  <div className="text-slate-900 font-medium">اجرای مجدد آخرین</div>
                  <div className="text-xs text-slate-500">content-generator</div>
                </div>
             </GlassCard>
             <GlassCard className="p-4 cursor-pointer hover:bg-slate-50 transition-colors flex items-center gap-4 group">
                <div className="w-10 h-10 rounded-lg bg-blue-50 border border-blue-100 flex items-center justify-center text-blue-600 group-hover:text-white group-hover:bg-blue-600 transition-all">
                  <Database className="w-5 h-5" />
                </div>
                <div>
                  <div className="text-slate-900 font-medium">مدیریت Drive</div>
                  <div className="text-xs text-slate-500">مشاهده فایل‌ها</div>
                </div>
             </GlassCard>
          </div>
        </div>
      </div>
    </div>
  );
};