import { GoogleGenAI } from "@google/genai";

// Initialize the client only if the key is available.
// In a real app, this would be handled via server-side proxy or careful env management.
const apiKey = process.env.API_KEY || ''; 

export const generateScriptIdea = async (prompt: string): Promise<string> => {
  if (!apiKey) {
    console.warn("API Key is missing for Gemini");
    return "API Key not configured.";
  }

  try {
    const ai = new GoogleGenAI({ apiKey });
    const response = await ai.models.generateContent({
      model: 'gemini-2.5-flash',
      contents: `You are an expert Google Apps Script developer. Provide a high-level architectural summary for a script that does the following: ${prompt}. Keep it under 100 words and in Persian.`,
    });

    return response.text || "خطایی در تولید پاسخ رخ داد.";
  } catch (error) {
    console.error("Gemini API Error:", error);
    return "متاسفانه ارتباط با هوش مصنوعی برقرار نشد.";
  }
};

export const analyzeKeywords = async (keywords: string[]): Promise<string> => {
    if (!apiKey) return "API Key Missing";
    
    try {
        const ai = new GoogleGenAI({ apiKey });
        const response = await ai.models.generateContent({
            model: 'gemini-2.5-flash',
            contents: `Categorize these keywords into semantic clusters: ${keywords.join(', ')}. Return JSON format.`,
            config: {
                responseMimeType: 'application/json'
            }
        });
        return response.text || "{}";
    } catch (error) {
        return "{}";
    }
}