'use client';

import React from 'react';
import { Button } from '../ui/Button';
import { Sparkles } from 'lucide-react';
import Link from 'next/link';

export const CtaSection: React.FC = () => {
  return (
    <section className="py-24 relative">
      <div className="container mx-auto px-4">
        <div className="relative rounded-3xl bg-gradient-to-r from-purple-900 via-indigo-900 to-purple-900 p-12 md:p-20 text-center overflow-hidden shadow-2xl shadow-purple-900/20">
          
          {/* Animated Background Mesh */}
          <div className="absolute inset-0 bg-[url('https://grainy-gradients.vercel.app/noise.svg')] opacity-20 mix-blend-soft-light"></div>
          <div className="absolute -top-24 -left-24 w-96 h-96 bg-purple-500/30 rounded-full blur-[128px]"></div>
          <div className="absolute -bottom-24 -right-24 w-96 h-96 bg-blue-500/30 rounded-full blur-[128px]"></div>

          <div className="relative z-10 max-w-3xl mx-auto">
            <h2 className="text-4xl md:text-5xl font-bold text-white mb-6">آماده شروع هستید؟</h2>
            <p className="text-lg text-purple-100 mb-10">
              به جمع هزاران کاربری بپیوندید که کارهای خود را با Autom8 خودکار کرده‌اند. 
              همین حالا رایگان شروع کنید.
            </p>
            <Link href="/dashboard">
              <Button size="lg" className="bg-white text-purple-900 hover:bg-slate-100 hover:scale-105 border-0">
                <Sparkles className="w-5 h-5 ml-2" />
                شروع رایگان
              </Button>
            </Link>
          </div>
        </div>
      </div>
    </section>
  );
};

