import React from 'react';
import { UserPlus, CheckSquare, Settings, Rocket } from 'lucide-react';

export const HowItWorks: React.FC = () => {
  const steps = [
    {
      icon: UserPlus,
      title: "ثبت‌نام",
      desc: "با حساب Google خود وارد شوید"
    },
    {
      icon: CheckSquare,
      title: "انتخاب اسکریپت",
      desc: "اسکریپت مورد نظر را از کتابخانه انتخاب کنید"
    },
    {
      icon: Settings,
      title: "تنظیمات",
      desc: "تنظیمات را وارد کنید (API Keys، Folder IDs)"
    },
    {
      icon: Rocket,
      title: "اجرا",
      desc: "اسکریپت را اجرا کنید و نتایج را مشاهده کنید"
    }
  ];

  return (
    <section className="py-20 relative overflow-hidden">
      <div className="container mx-auto px-4 relative z-10">
        <div className="text-center mb-20">
          <h2 className="text-3xl md:text-5xl font-bold text-slate-900 mb-6">چگونه کار می‌کند؟</h2>
          <p className="text-slate-600">فقط ۴ مرحله تا خودکارسازی کارهای شما فاصله است</p>
        </div>

        <div className="grid grid-cols-1 md:grid-cols-4 gap-8 relative">
          {/* Connecting Line (Desktop) */}
          <div className="hidden md:block absolute top-12 left-0 right-0 h-0.5 bg-gradient-to-r from-purple-200/0 via-purple-200 to-purple-200/0"></div>

          {steps.map((step, index) => (
            <div key={index} className="relative flex flex-col items-center text-center group">
              <div className="w-24 h-24 rounded-2xl bg-white border border-slate-200 shadow-lg shadow-slate-200/50 flex items-center justify-center relative z-10 mb-6 group-hover:scale-110 transition-transform duration-300">
                <div className="absolute inset-0 bg-purple-50 rounded-2xl group-hover:bg-purple-100 transition-colors"></div>
                <step.icon className="w-10 h-10 text-purple-600 relative z-10" />
                <div className="absolute -top-3 -right-3 w-8 h-8 rounded-full bg-purple-600 text-white flex items-center justify-center font-bold text-sm border-4 border-slate-50">
                  {index + 1}
                </div>
              </div>
              <h3 className="text-xl font-bold text-slate-900 mb-2">{step.title}</h3>
              <p className="text-slate-600 text-sm px-4">{step.desc}</p>
            </div>
          ))}
        </div>
      </div>
    </section>
  );
};

